//
//  ViewController.swift
//  Demo-DeepLink
//
//  Created by kirill on 12/10/19.
//  Copyright © 2019 Inspector Cloud. All rights reserved.
//

import UIKit

import ICDeepLink

class ViewController: UIViewController {

    @IBOutlet weak var schemeTextField: UITextField!
    @IBOutlet weak var tokenTextField: UITextField!
    @IBOutlet weak var userIdTextField: UITextField!
    @IBOutlet weak var customerIdTextField: UITextField!
    @IBOutlet weak var visitIdTextField: UITextField!
    @IBOutlet weak var filterTextField: UITextField!
    @IBOutlet weak var readOnlySwitch: UISwitch!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        schemeTextField.text = ICDeepLinkService.shared.scheme
        userIdTextField.text = ICDeepLinkService.shared.agentId
        visitIdTextField.text = UUID().uuidString
        
        if let scheme = UserDefaults.standard.string(forKey: "scheme") {
            ICDeepLinkService.shared.scheme = scheme
            schemeTextField.text = scheme
        }
        
        if let token = UserDefaults.standard.string(forKey: "token") {
            ICDeepLinkService.shared.token = token
            tokenTextField.text = token
        }
        
        if let agentId = UserDefaults.standard.string(forKey: "agentId") {
            ICDeepLinkService.shared.agentId = agentId
            userIdTextField.text = agentId
        }
        
        if let customerId = UserDefaults.standard.string(forKey: "customerId") {
            customerIdTextField.text = customerId
        }
        
        if let visitId = UserDefaults.standard.string(forKey: "visitId") {
            visitIdTextField.text = visitId
        }
        
        if let filter = UserDefaults.standard.string(forKey: "filter") {
            filterTextField.text = filter
        }
        
        readOnlySwitch.isOn = UserDefaults.standard.bool(forKey: "readonly")
        
        ICDeepLinkService.shared.delegate = self
        
        let tapGesture = UITapGestureRecognizer(target: self, action: #selector(dismissKeyboard))
        tapGesture.cancelsTouchesInView = false
        view.addGestureRecognizer(tapGesture)
    }
    
    @objc func dismissKeyboard() {
        view.endEditing(true)
    }
    
    
    @IBAction func changedSchemeAction(_ sender: UITextField) {
        UserDefaults.standard.setValue(sender.text ?? "", forKey: "scheme")
        ICDeepLinkService.shared.scheme = sender.text
    }
    
    @IBAction func changedTokenAction(_ sender: UITextField) {
        UserDefaults.standard.setValue(sender.text ?? "", forKey: "token")
        ICDeepLinkService.shared.token = sender.text
    }
    
    @IBAction func changedUserAction(_ sender: UITextField) {
        UserDefaults.standard.setValue(sender.text ?? "", forKey: "agentId")
        ICDeepLinkService.shared.agentId = sender.text
    }
    
    @IBAction func changedCustomerAction(_ sender: UITextField) {
        UserDefaults.standard.setValue(sender.text ?? "", forKey: "customerId")
    }
    
    @IBAction func changedVisitAction(_ sender: UITextField) {
        UserDefaults.standard.setValue(sender.text ?? "", forKey: "visitId")
    }
    
    @IBAction func changedFilterAction(_ sender: UITextField) {
        UserDefaults.standard.setValue(sender.text ?? "", forKey: "filter")
    }
    
    @IBAction func readOnlyAction(_ sender: UISwitch) {
        UserDefaults.standard.setValue(sender.isOn, forKey: "readonly")
    }
    
    @IBAction func syncAction(_ sender: Any) {
        let customerIds = (customerIdTextField.text ?? "").split(separator: ",").map { String($0) }
        ICDeepLinkService.shared.sync(customerIds: customerIds)
    }
    
    @IBAction func openAction(_ sender: Any) {
        ICDeepLinkService.shared.openVisit(visitId: visitIdTextField.text ?? "",
                                    customerId: customerIdTextField.text ?? "",
                                    isReadonly: readOnlySwitch.isOn,
                                    filter: filterTextField.text ?? "")
    }
}


extension ViewController: ICDeepLinkDelegate {
    func receive(customerId: String, totalImages: Int) {
        print("")
    }
    
    func sync(status: Bool) {
        print("")
    }
    
    func error(_ error: ICDeepLinkError) {
        print("")
    }
    
}
