# ICDeepLink 1.1.3

Библиотека для работы с визитами в приложении IC Camera.

## Установка

1. В `Xcode` в `Project Navigator` добавьте файл `ICDeepLink.xcframework`. В открывшемся диалоге выберите опции `Copy files to destination`, `Create groups` и правильный таргет.
2. Если у вас в проекте есть `ICDeepLink.framework` предыдущей версии, то удалите его. Для этого нажмите на него и выберите `Delete`. В открывшемся диалоге выберите `Move to trash`.
3. Убедитесь, что в таргете в разделе `General` -> `Frameworks, Libraries, and Embedded Comtent` присутствует `ICDeepLink.xcframework` со значением `Embed & Sign`.
4. Убедитесь, что в `Build Phases` в `Link Binary With Libraries` присутствует `ICDeepLink.xcframework` со статусом `Required`.

Фрэймворк готов к использованию.

## Настройка

Для начала работы с библиотекой необходимо выполнить настройку нескольких ключевых параметров:

**scheme** - используется для того, чтобы вернуться в ваше приложение из IC Camera. Для этого добавьте новую схему в разделе URL Types вашего проекта в Xcode, а затем выполните следующий код:

```
ICDeepLinkService.shared.scheme = "ваша_схема"
```

**token** - необходим для доступа к приложению IC Camera и для того, чтобы начать визит. Пример установки токена:

```
ICDeepLinkService.shared.token = "ваш_токен"
```

**agentId** - идентификатор пользователя, используемый для идентификации в системе. Установите его следующим образом:

```
ICDeepLinkService.shared.agentId = "ваш_agent_id"
```

Во всех идентификаторах допустимо использование только следующих символов: A–Z, a–z, 0–9, -, _


### Синхронизация мастер-данных

Для работы в режиме офлайн необходимо выполнить синхронизацию мастер-данных. Мы рекомендуем выполнять синхронизацию раз в день в начале рабочего дня при стабильном подключении к интернету. Для запуска синхронизации укажите список идентификаторов магазинов следующим образом:

```swift
ICDeepLinkService.shared.sync(customerIds: ["id1", "id2", "id3"])
``` 

После завершения синхронизации управление передается обратно в вызывающее приложение. Статус синхронизации и возможные ошибки можно отследить через методы делегата:

```swift
func sync(status: Bool)
``` 

**status** - статус синхронизации. Если значение true, синхронизация прошла успешно, если false — произошла ошибка, и необходимо повторить попытку.

Для получения информации об ошибке синхронизации используйте метод:

```swift
func error(_ error: ICDeepLinkError)
``` 
**error** - код ошибки. Если синхронизация прошла неуспешно, в этот метод будет передан соответствующий код ошибки.

### Переход в приложение Inspector Cloud

Для начала нового визита или просмотра существующего, вызовите следующую функцию:

```swift
ICDeepLinkService.shared.openVisit(visitId: "visitId",
                            customerId: "customerId",
                            isReadonly: false,
                            filter: "")
```

- **visitId** - идентификатор визита
- **customerId** - идентификатор точки (магазина), в которой будет выполнен визит
- **filter** - (опционально) фильтр задач, применяемый для отображения только тех задач, которые удовлетворяют заданному регулярному выражению ([описание](https://developer.android.com/reference/java/util/regex/Pattern)). Если фильтр не задан, будут показаны все задачи.
- **readonly** - флаг, определяющий, будет ли визит открыт только для чтения. В режиме чтения задачи доступны только для просмотра.

### Обработка входящих ссылок

После завершения визита в приложении IC Camera происходит автоматический возврат в приложение, из которого был начат визит. Для обработки входящих ссылок используйте следующий метод в классе **SceneDelegate**:

```
func scene(_ scene: UIScene, openURLContexts URLContexts: Set<UIOpenURLContext>) {
    for context in URLContexts {
        ICDeepLinkService.shared.proceedDeeplink(url: context.url)
    }
}
```

### Подписка на делегат

Чтобы получить информацию о завершенном визите и магазине, в котором он был выполнен, подпишитесь на делегат **ICDeepLinkDelegate**:

```
ICDeepLinkService.shared.delegate = self
```

Метод делегата будет вызван при возврате в ваше приложение:

```
func receive(customerId: String, totalImages: Int)
```

- **customerId** — идентификатор точки, в которой был выполнен визит.
- **totalImages** — общее количество изображений, сделанных во время визита.

Эта документация поможет вам быстро настроить и использовать библиотеку **ICDeepLink** для интеграции с приложением IC Camera.
